﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace gyak10_4_Aknakereso
{
    public partial class FrmAknakeresoUI:Form
    {
        private List<List<Label>> tablaUI = new List<List<Label>>();
        private List<List<Akna>> tablaAdat = new List<List<Akna>>();
        private int tablaMeret = 15;
        private int aknakSzama = 30;
        private int zaszlokUISzama;
        private int zaszlokSzamaTalalt;

        public FrmAknakeresoUI()
        {
            InitializeComponent();
            TablaUIInicializalo();
            TablaAdatInicializalo();
        }

        private void TablaAdatInicializalo()
        {
            Random r = new Random();
            int tempX,tempY,lerakottAknakSzama = 0;
            for(int i = 0;i < tablaMeret;i++)
            {
                tablaAdat.Add(new List<Akna>());
                for(int j = 0;j < tablaMeret;j++)
                {
                    tablaAdat[i].Add(new Akna(i,j));
                }
            }
            do
            {
                tempX = r.Next(tablaMeret);
                tempY = r.Next(tablaMeret);
                if(tablaAdat[tempX][tempY].Cella == Mezo.Ures)
                {
                    tablaAdat[tempX][tempY].Cella = Mezo.Akna;
                    //tablaUI[tempX][tempY].Text = "A";
                    lerakottAknakSzama++;
                }
            } while(lerakottAknakSzama < aknakSzama);
        }

        private void TablaUIInicializalo()
        {
            int mezoMeret = 20;
            int margo = 3;
            for(int i = 0;i < tablaMeret;i++)
            {
                tablaUI.Add(new List<Label>());
                for(int j = 0;j < tablaMeret;j++)
                {
                    tablaUI[i].Add(new Label());
                    tablaUI[i][j].Size = new Size(mezoMeret,mezoMeret);
                    tablaUI[i][j].Location = new Point(margo + mezoMeret * i,margo + mezoMeret * j);
                    tablaUI[i][j].BorderStyle = BorderStyle.FixedSingle;
                    tablaUI[i][j].MouseClick += Label_Click;
                    tablaUI[i][j].Image = null;
                }
            }
        }

        private void Label_Click(object sender, MouseEventArgs e)
        {
            if(e.Button == MouseButtons.Right) { JobbClick(sender as Label); }
            if(e.Button == MouseButtons.Left)
            {
                var tempAdatCella = (sender as Label).AdatCella(tablaUI,tablaAdat);
                if((tempAdatCella.Cella != Mezo.Kibontott) && !(tempAdatCella.VanZaszlo)) { BalClick(sender as Label); }
            }
        }

        private void JobbClick(Label cella)
        {
            var adatCella = cella.AdatCella(tablaUI,tablaAdat);
            if((adatCella.Cella != Mezo.Kibontott) && (zaszlokUISzama < aknakSzama) && (cella.Image == null))
            {
                cella.Image = Akna.kepZaszlo;
                if(cella.Akna(tablaUI, tablaAdat))
                {
                    zaszlokSzamaTalalt++;
                    if(zaszlokSzamaTalalt == aknakSzama)
                    {
                        MessageBox.Show("Gratulálok, nyertél!");
                        Application.OpenForms.OfType<gyak10_4.FrmMain>().Single().Show();
                        this.Close();
                    }
                }
                zaszlokUISzama++;
                adatCella.VanZaszlo = true;
            }
            else
            {
                if(adatCella.VanZaszlo)
                {
                    cella.Image = null;
                    if(cella.Akna(tablaUI,tablaAdat))
                    {
                        zaszlokSzamaTalalt--;
                    }
                    zaszlokUISzama--;
                    adatCella.VanZaszlo = false;
                }
            }
        }

        private void BalClick(Label cella)
        {
            if(cella.Akna(tablaUI,tablaAdat))
            {
                foreach(var item in tablaUI)
                {
                    foreach(var tempCella in item)
                    {
                        if(tempCella.Akna(tablaUI,tablaAdat))
                        { 
                            tempCella.Image = Akna.kepAkna;
                        }
                        tempCella.MouseClick -= Label_Click;
                    }
                }
            }
            else
            {
                if(!cella.Akna(tablaUI,tablaAdat))
                {
                    MezoNemAknaKatt(cella);
                }
            }
        }

        private void MezoNemAknaKatt(object AktualisMezo)
        {
            var aktualisMezo = AktualisMezo as Label;
            var adat = Invoke((Func<Akna>)(() => aktualisMezo.AdatCella(tablaUI,tablaAdat))) as Akna;
            if((adat.Cella == Mezo.Kibontott) || (adat.VanZaszlo)) { return; }
            Invoke((Action)(() => adat.Cella = Mezo.Kibontott));
            aktualisMezo.Invoke((Action)(() => aktualisMezo.BorderStyle = BorderStyle.Fixed3D));

            if(adat.AknaSzamoloMezoKorul(tablaAdat) == 0)
            {
                foreach(var item in Akna.iranyVektorok)
                {
                        //MezoNemAknaKatt(tablaUI[aktualisMezo.PosX(tablaUI,item.Value.X)][aktualisMezo.PosY(tablaUI,item.Value.Y)]);
                        new Thread(() => MezoNemAknaKatt(tablaUI[aktualisMezo.PosX(tablaUI,item.Value.X)][aktualisMezo.PosY(tablaUI,item.Value.Y)])).Start();
                }
            }
            else
            {
                aktualisMezo.Invoke((Action)(() => aktualisMezo.Text = adat.AknaSzamoloMezoKorul(tablaAdat).ToString()));
                return;
            }
        }

        private void FrmAknakeresoUI_Load(object sender,EventArgs e)
        {
            foreach(var item in tablaUI)
            {
                foreach(var temp in item)
                {
                    this.Controls.Add(temp);
                }
            }
        }

        private void FrmAknakeresoUI_FormClosing(object sender,FormClosingEventArgs e)
        {
            Application.OpenForms[0].Show();
        }
    }
}