﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Reflection;

namespace gyak10_4_Aknakereso
{
    public enum Mezo
    {
        Ures, Akna, Kibontott
    };

    public class Akna
    {
        public Mezo Cella { get; set; }
        public int PosX { get; private set; }
        public int PosY { get; private set; }
        public bool VanZaszlo { get; set; }
        public static Dictionary<string,Iranyok> iranyVektorok = new Dictionary<string,Iranyok>()
        {
            {"Fel",new Iranyok(0,-1)},
            {"JobbFel",new Iranyok(1,-1)},
            {"Jobb",new Iranyok(1,0)},
            {"JobbLe",new Iranyok(1,1)},
            {"Le",new Iranyok(0,1)},
            {"BalLe",new Iranyok(-1,1)},
            {"Bal",new Iranyok(-1,0)},
            {"BalFel",new Iranyok(-1,-1)}
        };

        public Akna(int posX, int posY)
        {
            this.PosX = posX;
            this.PosY = posY;
        }

        public static Image kepAkna
        {
            get
            {
                return Image.FromStream(Assembly.GetExecutingAssembly().GetManifestResourceStream("gyak10_4.Resources.aknaMezo2.png"));
            }
        }

        public static Image kepZaszlo
        {
            get
            {
                return Image.FromStream(Assembly.GetExecutingAssembly().GetManifestResourceStream("gyak10_4.Resources.zaszlo.png"));
            }
        }
        
        public int AknaSzamoloMezoKorul(List<List<Akna>> tablaAdat)
        {
            int eredmeny = 0;

            Func<Iranyok,bool> aknaSzamoloBelso = elem =>
                {
                    try
                    {
                        return tablaAdat[PosX + elem.X][PosY + elem.Y].Cella == Mezo.Akna ? true : false;
                    }
                    catch(Exception)
                    {
                        return false;
                    }
                };
            foreach(var item in iranyVektorok)
            {
                eredmeny += aknaSzamoloBelso(item.Value) ? 1 : 0;
            }
            return eredmeny;
        }
    }
}
