﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Amoba
{
    public partial class FrmJatekTabla:Form
    {
        private List<List<Label>> tablaUI;
        private JatekTabla tablaAdatKezelo;
        private Jatekos aktivJatekos;
        public Jatekos Jatekos1 { get; set; }
        public Jatekos Jatekos2 { get; set; }
        private int margo = 2;
        private int labelMeret = 20;
        private int ugrasX = 0;
        private int ugrasY = 0;
        private int tablaMeret = 15;
        public static readonly int nyeresiHatar = 3; //Ennyi jel + 1-nél kell több a nyeréshez: Min. 4 + amit épp leraktak => 5 jellel nyertek, nem igazi paraméter, mert
                                                     //át kellene írni a kiértékelő methodot a JatekTabla classban, ha távolabb akarunk keresni

        public FrmJatekTabla(JelTipusok valasztottJel)
        {
            InitializeComponent();
            tablaAdatKezelo = new JatekTabla(tablaMeret);
            tablaUI = new List<List<Label>>();
            UIInicializalasCellak();
            Jatekos1 = new Jatekos(valasztottJel);
            Jatekos2 = valasztottJel == JelTipusok.O ? new Jatekos(JelTipusok.X) : new Jatekos(JelTipusok.O);
            aktivJatekos = Jatekos1.AktivKor ? Jatekos1 : Jatekos2;
        }

        private void UIInicializalasCellak()
        {
            for(int i = 0;i < tablaMeret;i++)
            {
                tablaUI.Add(new List<Label>());
                ugrasX = 0;
                for(int j = 0;j < tablaMeret;j++)
                {
                    tablaUI[i].Add(new Label());
                    tablaUI[i][j].BorderStyle = BorderStyle.FixedSingle;  //keret a cellákhoz
                    tablaUI[i][j].Size = new System.Drawing.Size(labelMeret,labelMeret);
                    tablaUI[i][j].Location = new System.Drawing.Point(margo + ugrasX,margo + ugrasY);
                    tablaUI[i][j].AutoSize = false; //O miatt növelné a 15x15-öt
                    tablaUI[i][j].TextAlign = ContentAlignment.MiddleCenter;
                    ugrasX += labelMeret;
                    tablaUI[i][j].Click += Label_Click;
                }
                ugrasY += labelMeret;
            }
        }

        private void Label_Click(object sender,EventArgs e)
        {
            try
            {
                int x = tablaUI.FindIndex(oszlop => oszlop.Contains(sender as Label));
                int y = tablaUI[x].FindIndex(sor => sor.Equals(sender));
                if(tablaAdatKezelo.tablaAdat[x][y])
                {
                    tablaAdatKezelo.tablaAdat[x][y].AktualisJel = aktivJatekos.Jel;
                    tablaUI[x][y].Text = aktivJatekos.Jel.ToString();
                }
                else { throw new Exception(); }
                aktivJatekos.Lepett();
                aktivJatekos = aktivJatekos.Equals(Jatekos1) ? Jatekos2 : Jatekos1;
                if(tablaAdatKezelo.Kijott(tablaAdatKezelo.tablaAdat[x][y]) || !(tablaAdatKezelo.VanUresCella(tablaAdatKezelo.tablaAdat)))
                {
                    MessageBox.Show("A játék véget ért.","Vége");
                    this.Close();
                }
                lblKiKovetkezik.Text = aktivJatekos.Jel.ToString();
            }
            catch(Exception)
            {
                return;
            }
        }

        private void FormJatekTabla_Load(object sender,EventArgs e)
        {
            foreach(var temp in tablaUI)
            {
                foreach(var temp2 in temp)
                {
                    pnlJatekTabla.Controls.Add(temp2);
                }
            }
        }
    }
}
